<?php

use App\Http\Controllers\ClientController;
use App\Http\Controllers\DriverController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\SitemapController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\DriverForgotPasswordController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [HomeController::class, 'home'])->name('homepage');  
Route::get('/contact-us', [HomeController::class, 'contactus'])->name('contactus');
Route::get('/about-us', [HomeController::class, 'aboutus'])->name('aboutus');
Route::get('/rent-vehicle', [HomeController::class, 'rent'])->name('rent');
Route::get('/video-portal', [HomeController::class, 'video_portal'])->name('video-portal');  

Route::get('/rentcar-detail/{slug}', [HomeController::class, 'rentcar_detail'])->name('rentcar-detail');
Route::get('/packages', [HomeController::class, 'packages'])->name('packages');
Route::get('/package-detail', [HomeController::class, 'package_detail'])->name('package_detail');
Route::get('/payment', [HomeController::class, 'payment'])->name('payment');

Route::get('/aliya', [HomeController::class, 'aliya'])->name('aliya');
Route::get('araliya', [HomeController::class, 'araliyanew'])->name('araliyanew');
Route::get('/green-escapes', [HomeController::class, 'green_escapes'])->name('green_escapes');
Route::get('/hop-on', [HomeController::class, 'hop_on'])->name('hop_on');
Route::get('/luxe-looks', [HomeController::class, 'luxe_looks'])->name('luxe_looks');
Route::get('/royal-route', [HomeController::class, 'royal_route'])->name('royal_route');
Route::get('/trendy-treasures', [HomeController::class, 'trendy_treasures'])->name('trendy_treasures');
Route::get('/wander-rush', [HomeController::class, 'wander_rush'])->name('wander_rush');

Route::post('/order', [HomeController::class, 'order'])->name('order');
Route::POST('/paymentRedirect', [HomeController::class, 'paymentRedirect'])->name('paymentRedirect');

Route::get('/yala-safari', [HomeController::class, 'yala_safari'])->name('yala');
Route::get('/safari/{slug}', [HomeController::class, 'safaridetail'])->name('safaridetail');

Route::get('/minneriya-safari', [HomeController::class, 'minneriya_safari'])->name('minneriya');
Route::get('/udawalawa-safari', [HomeController::class, 'udawalawa_safari'])->name('udawalawa');
Route::get('/wilpatthu-safari', [HomeController::class, 'wilpatthu_safari'])->name('wilpatthu');
Route::get('/bandula-safari', [HomeController::class, 'bandula_safari'])->name('bandula');
Route::get('/mirissa-and-trincomalee-whale-watching', [HomeController::class, 'mirissa'])->name('mirissa');
Route::get('/tincomalee ', [HomeController::class, 'trinco'])->name('trinco');
Route::get('/cruises ', [HomeController::class, 'cruises'])->name('cruises');
Route::get('/cruises-destination/{slug} ', [HomeController::class, 'cruises_destination'])->name('cruises-destination');

Route::get('/bandula-safari', [HomeController::class, 'bandula_safari'])->name('bandula');
Route::get('/alert-success', [HomeController::class, 'alertSuccess'])->name('alert-success');
// Route::get('/ticket-price', [HomeController::class, 'ticket_price'])->name('ticket-price');
// Route::get('/railway-ticket', [HomeController::class, 'railway_ticket'])->name('railway_ticket');
// Route::get('/hotel-reservations', [HomeController::class, 'hotels'])->name('hotels');
Route::post('/booking', [HomeController::class, 'booking'])->name('booking');
Route::match(['get', 'post'],'/quotation', [HomeController::class, 'quotation'])->name('quotation');
Route::post('/sendmail', [HomeController::class, 'sendmail'])->name('sendmail');
Route::post('/new-safari', [HomeController::class, 'new_safari'])->name('new-safari');
Route::post('/new-cruise', [HomeController::class, 'new_cruise'])->name('new-cruise');
Route::post('/submit-inquiry', [HomeController::class, 'inquiry'])->name('inquiry');

Route::get('/add-video', [HomeController::class, 'addvideo'])->name('add-video');
Route::post('/insert-video', [HomeController::class, 'insertvideo'])->name('insertvideo');

Route::get('/destinations/{des}', [HomeController::class, 'destinations'])->name('destinations');

Route::get('/add-destinations', [HomeController::class, 'adddestinations'])->name('des.add');
Route::get('/map', [HomeController::class, 'map'])->name('map');

Route::get('/chatbot', [HomeController::class, 'chatbot'])->name('chatbot');
Route::post('/chat-send', [HomeController::class, 'chatsend'])->name('chatbot');

// Route::get('/news', [HomeController::class, 'news'])->name('news');
// Route::get('/news-detail/{slug}', [HomeController::class, 'newsdetail'])->name('news-detail');
// Route::get('/blog', [HomeController::class, 'blog'])->name('blog');
// Route::get('/blog-detail/{slug}', [HomeController::class, 'blog_detail'])->name('blog-detail');
Route::get('/tour-detail/{slug}', [HomeController::class, 'tourdetail'])->name('tour-detail');

Route::get('/loyalty-programme', [HomeController::class, 'loyaltyPage'])->name('loyalty-programme');
Route::get('/dialog-5g', [HomeController::class, 'communicationPartnerPage'])->name('dialog-5g');
Route::get('/tips', [HomeController::class, 'tips'])->name('tips');

Route::middleware('auth')->group(function () {

  //driver
  Route::get('/driver-insert', [DriverController::class, 'driverinsert'])->name('driver.insert');
  Route::Post('/driver-add', [DriverController::class,'driver_add'])->name('driver.add');
  Route::get('/driver-list', [DriverController::class, 'driverlist'])->name('driver.list');
  Route::get('/driver-plan/{id}', [DriverController::class, 'driverplan'])->name('driver-plan');
  Route::get('/driver-cancel/{id}', [DriverController::class, 'drivercancel'])->name('driver-cancel');
  Route::get('/driver-done/{id}', [DriverController::class, 'driverdone'])->name('driver-done');
  Route::get('/driver-delete/{id}', [AdminController::class, 'driverdelete'])->name('driver-delete');
  Route::get('/driver-edit/{id}', [AdminController::class, 'driveredit'])->name('driver-edit');
Route::Post('/driver-update', [AdminController::class,'driverupdate'])->name('driver.update');
  Route::get('/driver-itinerary/{id}', [DriverController::class, 'driver_itinerary'])->name('driver-itinerary');
  
Route::Post('/driver-job', [DriverController::class,'driver_job'])->name('driver.job');
  //
  Route::get('/loyalty', [AdminController::class, 'loyalty'])->name('loyalty.list');
  Route::get('/claim-approve/{id}', [AdminController::class, 'claim_approve'])->name('claim-approve');
  Route::get('/claim-disapprove/{id}', [AdminController::class, 'claim_disapprove'])->name('claim.disapprove');

    Route::post('/insert-destination', [AdminController::class, 'insertdestination'])->name('des.insert');
    Route::get('/admin', [AdminController::class, 'admin'])->name('admin');
    Route::get('/destination-delete/{id}', [AdminController::class, 'destdelete'])->name('destination-delete');
    Route::get('/des-imagedelete/{id}', [AdminController::class, 'des_imagedelete'])->name('des-imagedelete');

    Route::get('/destination-edit/{id}', [AdminController::class, 'destedit'])->name('destination-edit');
    Route::post('/destination-update/{id}', [AdminController::class, 'destupdate'])->name('destination-update');
    Route::get('/new-hotel', [AdminController::class, 'new_hotel'])->name('hotel.view');
    Route::post('/insert-Hotel', [AdminController::class, 'inserthotel'])->name('hotel.insert');
    Route::get('/hotel-list', [AdminController::class, 'hotel_list'])->name('hotel.list');
    Route::get('/hotel-delete/{id}', [AdminController::class, 'hoteldelete'])->name('hotel-delete');
    Route::get('/hotel-edit/{id}', [AdminController::class, 'hoteledit'])->name('hotel-edit');
    Route::post('/hotel-update/{id}', [AdminController::class, 'hotelupdate'])->name('hotel-update');
    Route::get('/cordelia-cruises', [AdminController::class, 'cordelia_cruises'])->name('cruise.list');
    Route::get('/cruise-edit/{id}', [AdminController::class, 'cruiseedit'])->name('cruise-edit');
    Route::post('/cordeliacruises-update/{id}', [AdminController::class, 'cordeliacruises_update'])->name('cruise-update');
    

    Route::get('/cruise-des/{id}', [AdminController::class, 'cruise_des'])->name('cruise-des');

    Route::get('/cruise-des-edit/{id}', [AdminController::class, 'cruise_desedit'])->name('cruise-des-edit');
    Route::get('/cruise-des-delete/{id}', [AdminController::class, 'cruise_desdelete'])->name('cruise-des-delete');
    
  Route::get('/desimg-delete/{slug} ', [AdminController::class, 'desimg_delete'])->name('desimg-delete');
    Route::get('/add-des/{id}', [AdminController::class, 'addtour'])->name('addtour');
    Route::post('/insert-tour', [AdminController::class, 'insert_tour'])->name('insert_tour');
    Route::post('/cruise-des-update', [AdminController::class, 'cruise_desupdate'])->name('cruise-des-update');



    Route::get('/blog-category', [AdminController::class,'blogcategory'])->name('blog-category');
    Route::post('/blog-cat-update', [AdminController::class, 'blogcatupdate'])->name('blog-cat-update');
    Route::get('/new-post', [AdminController::class,'new_post'])->name('blog.add');
    Route::get('/blog-posts', [AdminController::class,'blog'])->name('blog.view');
    Route::post('/insert-post', [AdminController::class, 'insert_post'])->name('insert-post');
    Route::get('/post-delete/{id}', [AdminController::class, 'postdelete'])->name('post-delete');
    Route::get('/post-edit/{id}', [AdminController::class, 'postedit'])->name('post-edit');
    Route::post('/post-update', [AdminController::class, 'postupdate'])->name('post-update');
    //vehicle
    Route::get('/vehicle-rent', [AdminController::class,'vehiclerent'])->name('vehiclerent.add');
    Route::post('/insert-vehicle', [AdminController::class, 'vehiclerentinsert'])->name('vehiclerent-insert');
    Route::get('/vehicle-list', [AdminController::class,'vehicle_list'])->name('vehicle-list');
    Route::get('/edit-vehicle/{id}', [AdminController::class,'edit_vehicle'])->name('vehicle-edit');
    Route::post('/update-vehicle/{id}', [AdminController::class, 'updatevehicle'])->name('vehicle-update');
    Route::get('/vehicle-delete/{id}', [AdminController::class, 'vehicledelete'])->name('vehicle-delete');
    
    //safari
    Route::get('/new-safari', [AdminController::class,'new_safari'])->name('new.safari');
    Route::get('/safari-list', [AdminController::class,'safari_list'])->name('safari_list');
    Route::post('/insert-safari', [AdminController::class, 'insertsafari'])->name('safari-insert');
    Route::get('/edit-safari/{id}', [AdminController::class,'edit_safari'])->name('safari-edit');
    Route::post('/update-safari/{id}', [AdminController::class, 'updatesafari'])->name('safari-update');
    Route::get('/safari-delete/{id}', [AdminController::class, 'safaridelete'])->name('safari-delete');
  


    //whale watching
    Route::get('/whale-watching-edit', [AdminController::class,'edit_whale_watching'])->name('whale-watching-edit');
    Route::post('/update-whale-watching', [AdminController::class, 'update_whale_watching'])->name('update-whale-watching');
    Route::get('/whale-imagedelete/{id}', [AdminController::class, 'whale_imagedelete'])->name('whale-imagedelete');
    
    //tour package
    Route::get('/new-package', [AdminController::class,'new_package'])->name('new.package');
    Route::get('/package-list', [AdminController::class,'package_list'])->name('package_list');
    Route::post('/insert-package', [AdminController::class, 'insert_package'])->name('package-insert');
    Route::get('/edit-package/{id}', [AdminController::class,'edit_package'])->name('package-edit');
    Route::post('/update-package/{id}', [AdminController::class, 'update_package'])->name('package-update');
    Route::get('/package-delete/{id}', [AdminController::class, 'package_delete'])->name('package-delete');
    //news
    Route::get('/new-news', [AdminController::class,'new_news'])->name('news.add');
    Route::get('/news-list', [AdminController::class,'news'])->name('news.view');
    Route::post('/insert-news', [AdminController::class, 'insert_news'])->name('insert-news');
    Route::get('/news-delete/{id}', [AdminController::class, 'newsdelete'])->name('news-delete');
    Route::get('/news-edit/{id}', [AdminController::class, 'newsedit'])->name('news-edit');
    Route::post('/news-update', [AdminController::class, 'newsupdate'])->name('news-update');

    //loyalty
    Route::get('/tour-sales/{id}', [AdminController::class, 'tour_sales'])->name('tour-sales');
    Route::get('/client-list', [AdminController::class, 'client_list'])->name('client-list');
    Route::get('/client-delete/{id}', [AdminController::class, 'clientdelete'])->name('client-delete');
    Route::get('/tour-itinerary/{id}', [AdminController::class, 'tour_itinerary'])->name('tour-itinerary');
    Route::get('/tour-list', [AdminController::class, 'tour_list'])->name('tour-list');
    Route::get('/user-tour-list/{id}', [AdminController::class, 'usertour_list'])->name('user-tour-list');
    Route::get('/edit-itinerary/{id}', [AdminController::class, 'edit_itinerary'])->name('edit-itinerary');
    Route::post('/finished-tour', [AdminController::class, 'finishedtours'])->name('finished-tours');
    Route::post('/tour-adding', [AdminController::class, 'tour_adding'])->name('tour-adding');
    Route::post('/tour-update', [AdminController::class, 'tour_update'])->name('tour-update');
    Route::get('/full-payment/{id}', [AdminController::class, 'fullpayment'])->name('full-payment');
    Route::get('/complete/{id}', [AdminController::class, 'complete'])->name('complete');
    Route::get('/delete-touritinerary/{id}', [AdminController::class, 'deletetour'])->name('delete-touritinerary');

    Route::get('/contact-page', [PageController::class,'contactpage'])->name('contact-page');
    Route::post('/contact-update', [PageController::class, 'contactupdate'])->name('contact-update');
    Route::get('/aboutus-page', [PageController::class,'aboutuspage'])->name('aboutus-page');
    Route::post('/aboutus-update', [PageController::class,'aboutusUpdate'])->name('aboutus-update');
    Route::get('/faq', [AdminController::class, 'faq'])->name('faq');
    Route::post('/faq-upadate', [AdminController::class,'faqupadate'])->name('faq-upadate');
    Route::get('/homepage', [PageController::class, 'homepage'])->name('homepage');
    Route::post('/homepage-update', [PageController::class, 'homepageupdate'])->name('homepage-update');
    Route::get('/innerbaner', [PageController::class, 'innerbaner'])->name('innerbaner');
    Route::post('/baner-update', [PageController::class, 'banerupdate'])->name('baner-update');
    Route::get('/footer', [PageController::class,'footer'])->name('footer');
    Route::get('/ticket-page', [PageController::class, 'ticketpage'])->name('ticketpage');
    Route::post('/ticketpage-update', [PageController::class, 'ticketpageupdate'])->name('ticketpage-update');
    Route::post('/footer-update', [PageController::class, 'footerupdate'])->name('footer-update');
    Route::get('/facilites-section', [PageController::class, 'facilitessection'])->name('facilites-section');
    Route::post('/facilitesection-update', [PageController::class, 'facilitesectionupdate'])->name('facilitesection-update');

    Route::get('/last-edit', [AdminController::class,'lastedit'])->name('last-edit');
    Route::post('/last-update', [AdminController::class, 'lastsection'])->name('lastsection-update');


    
    Route::get('/new-video', [AdminController::class, 'newvideo'])->name('new-video');
    Route::get('/youtubevideolist', [AdminController::class, 'youtubevideolist'])->name('youtubevideolist');
    Route::post('/add-youtubevideo', [AdminController::class, 'addyoutubevideo'])->name('add-youtubevideo');

    Route::post('/portal-description', [AdminController::class, 'portaldescription'])->name('portal-description');
    Route::get('/edit-youtubevideo/{id}', [AdminController::class, 'edityoutubevideo'])->name('edit-youtubevideo');
    Route::get('/delete-youtubevideo/{id}', [AdminController::class, 'deleteyoutubevideo'])->name('delete-youtubevideo');
    Route::post('/update-youtubevideo/{id}', [AdminController::class, 'updateyoutubevideo'])->name('update-youtubevideo');
    
    Route::get('/new-client', [AdminController::class, 'showClientRegistrationForm'])->name('new-client');
Route::post('/client/register', [AdminController::class, 'clintsrore'])->name('client-register');
});
//cilent register
// Route::get('/new-client', [RegisteredUserController::class, 'showClientRegistrationForm'])->name('new-client');
// Route::post('/client/register', [RegisteredUserController::class, 'clintsrore'])->name('client-register');




Route::prefix('client')->group(function () {
  Route::group(['middleware' => 'auth.newclient'], function () {
    Route::get('/client-dashbord', [ClientController::class, 'client_dashbord'])->name('client.dashbord');
    Route::get('/my-tour-list', [ClientController::class, 'mytours'])->name('client.mytours');
    Route::get('/view-itinerary/{id}', [ClientController::class, 'view_itinerary'])->name('client.view-itinerary');
  });
  Route::get('/client-login', [ClientController::class, 'clientlogin'])->name('client.show');
  Route::Post('/client-login', [ClientController::class, 'login'])->name('client.login');
  Route::get('/logout',  [ClientController::class, 'clientLogout'])->name('client.logout');

});

Route::Post('/point-claim', [ClientController::class,'point_claim'])->name('point.claim');

// Route::get('/sitemap.xml', [SitemapController::class, 'index']);

Route::get('/driver/driver-login', [DriverController::class, 'driverlogin'])->name('driver.show');
Route::get('/driver/driver-dashbord', [DriverController::class, 'riderdashbord'])->name('driver.dashbord');
Route::Post('/driver-login', [DriverController::class, 'login'])->name('driver.login');
Route::get('/driver/logout',  [DriverController::class, 'driverLogout'])->name('driver.logout');


Route::group(['middleware' => 'auth.newdriver'], function () {
  Route::get('/driver/driver-dashbord', [DriverController::class, 'riderdashbord'])->name('driver.dashbord');
  Route::get('/driver/complete', [DriverController::class, 'ridercomplete'])->name('driver.complete');
  Route::get('/driver/job-view/{id}', [DriverController::class, 'jobview'])->name('driver.job-view');
});

Route::get('/rider/{slug}', [DriverController::class, 'rider'])->name('rider');
///foregt
Route::get('forget-password', [ForgotPasswordController::class, 'showForgetPasswordForm'])->name('forget.password.get');
Route::post('forget-password', [ForgotPasswordController::class, 'submitForgetPasswordForm'])->name('forget.password.post'); 
Route::get('reset-password/{token}', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('reset.password.get');
Route::post('reset-password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');

///foregt
Route::get('/driver/forget-password', [DriverForgotPasswordController::class, 'showForgetPasswordForm'])->name('driver.forget.password.get');
Route::post('/driverforget-password', [DriverForgotPasswordController::class, 'submitForgetPasswordForm'])->name('driver.forget.password.post'); 
Route::get('/driver/reset-password/{token}', [DriverForgotPasswordController::class, 'showResetPasswordForm'])->name('driver.reset.password.get');
Route::post('/driver/reset-password', [DriverForgotPasswordController::class, 'submitResetPasswordForm'])->name('driver.reset.password.post');

Route::get('/display-job/{uid}', [DriverController::class, 'displayjob'])->name('newjob');

Route::get('/cookie-policy', [PageController::class,'cookiePolicy'])->name('cookie-policy');
Route::get('/privacy-policy', [PageController::class,'privacyPolicy'])->name('privacy-policy');
Route::get('/odr', [PageController::class,'odr'])->name('odr');
Route::get('/terms-and-conditions', [PageController::class,'termsandCondition'])->name('terms-and-conditions');

require __DIR__.'/auth.php';